/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Text;

namespace Borland.Eco.Persistence
{
	[Serializable]
	public class ContentEqualArray
	{
		private System.Object[] m_InternalArray;

		public ContentEqualArray(int size): base()
		{
		  m_InternalArray = new System.Object[size]; // SetLength(fArray, Size);
		}
		public override int GetHashCode()
		{
			int res = 0;
			foreach (System.Object item in m_InternalArray)
				if (item != null)
					res ^= item.GetHashCode();
			return res;
		}
		public override bool Equals(System.Object obj)
		{
			bool res = false;
			ContentEqualArray otherArray = obj as ContentEqualArray;
			if (otherArray != null)
			{
				if (otherArray.Size == Size)
				{
					res = true;
					for (int i = 0; i < Size; i++)
					{
						if (GetItem(i) == null)
							res &= (otherArray.GetItem(i) == null);
						else
							res &= GetItem(i).Equals(otherArray.GetItem(i));
					}
				}
			}
			return res;
		}
		public override string ToString()
		{
			StringBuilder sb = new StringBuilder();
			sb.Append("Composite Id ("); // do not localize
			for (int i=0; i<Size; i++)
			{
				if (i != 0)
					sb.Append(", "); // do not localize
				if (GetItem(i) != null)
					sb.Append(GetItem(i));
				else
					sb.Append("null"); // do not localize
			}
			sb.Append(")"); // do not localize
			return sb.ToString();
		}

		public System.Object GetItem(int index)
		{
		  return m_InternalArray[index];
		}
		public void SetItem(int index, System.Object value)
		{
			m_InternalArray[index] = value;
		}
		public int Size { get { return m_InternalArray.Length; } }
	}
}

/*



function ContentEqualArray.GetItem(index: integer): System.Object;
begin
end;


procedure ContentEqualArray.SetItem(index: integer; const Value: System.Object);
begin
end;

function ContentEqualArray.ToString: string;
var
  i: integer;
begin
end;
*/